class MonsterMatch expands Mutator config(MonsterMatch);

#exec TEXTURE IMPORT NAME=Skin_EliteKrali FILE=Textures\Skin_EliteKrali.bmp GROUP="Monsters" MIPS=OFF
#exec TEXTURE IMPORT NAME=Skin_ElitePupie FILE=Textures\Skin_ElitePupie.bmp GROUP="Monsters" MIPS=OFF
#exec TEXTURE IMPORT NAME=Skin_EliteBrutie FILE=Textures\Skin_EliteBrutie.bmp GROUP="Monsters" MIPS=OFF
#exec TEXTURE IMPORT NAME=Skin_ToxicBrutie FILE=Textures\Skin_ToxicBrutie.bmp GROUP="Monsters" MIPS=OFF
#exec TEXTURE IMPORT NAME=Skin_RazorBrutie FILE=Textures\Skin_RazorBrutie.bmp GROUP="Monsters" MIPS=OFF
#exec TEXTURE IMPORT NAME=Skin_EliteSnake FILE=Textures\Skin_EliteSnake.bmp GROUP="Monsters" MIPS=OFF
#exec TEXTURE IMPORT NAME=Skin_EliteGassieA FILE=Textures\Skin_EliteGassieA.bmp GROUP="Monsters" MIPS=OFF
#exec TEXTURE IMPORT NAME=Skin_EliteGassieB FILE=Textures\Skin_EliteGassieB.bmp GROUP="Monsters" MIPS=OFF

#exec TEXTURE IMPORT NAME=Item_Health FILE=Textures\Item_Health.bmp GROUP="Items" MIPS=OFF FLAGS=2
#exec TEXTURE IMPORT NAME=Item_Ammo FILE=Textures\Item_Ammo.bmp GROUP="Items" MIPS=OFF FLAGS=2
#exec TEXTURE IMPORT NAME=Item_Armor FILE=Textures\Item_Armor.bmp GROUP="Items" MIPS=OFF FLAGS=2
#exec TEXTURE IMPORT NAME=Item_Tombstone FILE=Textures\Item_Tombstone.bmp GROUP="Items" MIPS=OFF FLAGS=2
#exec TEXTURE IMPORT NAME=Item_Imunity FILE=Textures\Item_Imunity.bmp GROUP="Items" MIPS=OFF FLAGS=2
#exec TEXTURE IMPORT NAME=Item_Vampire FILE=Textures\Item_Vampire.bmp GROUP="Items" MIPS=OFF FLAGS=2
#exec TEXTURE IMPORT NAME=Item_LethalAura FILE=Textures\Item_LethalAura.bmp GROUP="Items" MIPS=OFF FLAGS=2
#exec TEXTURE IMPORT NAME=Item_Speed FILE=Textures\Item_Speed.bmp GROUP="Items" MIPS=OFF FLAGS=2

#exec TEXTURE IMPORT NAME=MM256 FILE=Textures\MM256.bmp GROUP="Logo" MIPS=OFF

#exec Audio Import File="Sounds\ImunitySound.wav" Name="ImunitySound" GROUP="Sounds"
#exec Audio Import File="Sounds\LethalAuraSound.wav" Name="LethalAuraSound" GROUP="Sounds"
#exec Audio Import File="Sounds\SpeedBoostSound.wav" Name="SpeedBoostSound" GROUP="Sounds"
#exec Audio Import File="Sounds\VampireSound.wav" Name="VampireSound" GROUP="Sounds"

var bool bTDM;
var int Num;

//item duration time:
var config int	MaxPlayerHealth,
				TombstoneHealth,
				TombstoneLifetime,
				AmmoRegenTime,
				MaxAmmoCount,
				ImunityTime,
				SpeedBoostTime,
				LethalAuraTime,
				LethalAuraRadius,
				AuraDamagePerSecond,
				VampireTime,
				VampirePercentage,
				ChanceHealth,
				ChanceArmor,
				ChanceAmmoRegen,
				ChanceImunity,
				ChanceVampire,
				ChanceLethalAura,
				ChanceSpeedBoost;

function PreBeginPlay ()
{
local DeathMatchPlus DM;
local TeamGamePlus TDM;

	Super.PreBeginPlay();
	SaveConfig();
	
	//Detect if it's a DM or TDM game:
	if (GetItemName(string(Level.Game.Class)) == "TeamGamePlus")
	    bTDM = true;
	  else
	    bTDM = false;

	if ( bTDM )
		{
		Level.Game.GameName = "Team MonsterMatch";
		Level.Game.ScoreBoardType = Class'MM_TeamScoreBoard';
		Level.Game.HUDType = Class'MM_TDMHUD';
		ForEach AllActors(class'TeamGamePlus', TDM)
			{
			if ( TDM.GoalTeamScore != 0 )
				{
				TDM.GoalTeamScore = 0;
				TDM.TimeLimit = 10;
				log ("MonsterMatch v1.06: Gamesettings changed to default 10 minutes TimeLimit because of incorrect settings.");
				}
			}
		}
	else
		{
		Level.Game.GameName = "MonsterMatch";
		Level.Game.ScoreBoardType = Class'MM_ScoreBoard';
		Level.Game.HUDType = Class'MM_HUD';
		ForEach AllActors(class'DeathMatchPlus', DM)
			{
			if ( DM.FragLimit != 0 )
				{
				DM.FragLimit = 0;
				DM.TimeLimit = 10;
				log ("MonsterMatch v1.06: Gamesettings changed to default 10 minutes TimeLimit because of incorrect settings.");
				}
			}
		}

	//Level.Game.LeftMessage = " left the game.";
	//Level.Game.EnteredMessage = " entered the game.";

	AddMutator(Level.Spawn(class'MM_DamageMutator'));

	SetTimer(1.0,True);
	
}

function bool AlwaysKeep(Actor Other) 
{
	if (Other.IsA('TournamentPlayer'))
        	{
		Pawn(Other).PlayerReplicationInfoClass = class'MonsterPRI';
		return true;
		}
	if (Other.IsA('Monsters'))
        	{
		Monsters(Other).bIsPlayer = False;
		return true;
		}
	if (Other.IsA('Ammo'))
        	{
		Ammo(Other).MaxAmmo = MaxAmmoCount;
		return true;
		}

	if (NextMutator != None)
		return (NextMutator.AlwaysKeep(Other));
	
	return false;
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
local Inventory Inv;
local Weapon Weap, dropped;
local float speed;
local int NumAmmo;
local string MonsterClass,MonsterName;
local int Length, Dice, Chance;
local Item_Health ItemA;
local Item_Armor ItemB;
local Item_Ammo ItemC;
local Item_Imunity ItemD;
local Item_Vampire ItemE;
local Item_LethalAura ItemF;
local Item_Speed ItemG;
local Item_Tombstone T;
local MonsterPRI MPRI;
local bool bDrop;

	if ( Killer != None && Killer.IsA('PlayerPawn') )
		{
		MPRI = MonsterPRI(PlayerPawn(Killer).PlayerReplicationInfo);
		MPRI.NumKills++;
		if ( Killed.IsA('Monsters') );
			MPRI.NumMonsters--;
		}

	if ( Killed.IsA('PlayerPawn') || Killed.IsA('Bot') )
		{
		//Make sure player looses items when he dies - too bad!!
		if ( Killed.IsA('PlayerPawn') )
			{
			MPRI = MonsterPRI(PlayerPawn(Killed).PlayerReplicationInfo);
			if ( MPRI != none )
				{
				MPRI.AmmoRegenTime = 0;
				MPRI.ImunityTime = 0;
				MPRI.VampireTime = 0;
				MPRI.LethalAuraTime = 0;
				MPRI.SpeedBoostTime = 0;
				Killed.AirControl = Killed.Default.AirControl;
				Killed.JumpZ = Killed.Default.JumpZ;
				Killed.GroundSpeed = Killed.Default.GroundSpeed;
				Killed.WaterSpeed = Killed.Default.WaterSpeed;
				Killed.AirSpeed = Killed.Default.AirSpeed;
				Killed.Acceleration = Killed.Default.Acceleration;
				}
			}
		Killed.PlayerReplicationInfo.Deaths += 1;
		
		for (inv=Killed.Inventory; inv!=None; inv=inv.Inventory)
			{
			if (inv.IsA('Weapon') && !inv.IsA('ImpactHammer') && !inv.IsA('Translocator') )
				{

				weap = Weapon(inv);
				if ( weap != None && Weap.AmmoType != None && Weap.AmmoType.AmmoAmount > 0 )
					{

					NumAmmo = Weap.AmmoType.AmmoAmount;
					dropped = Spawn(weap.Class,,,Killed.Location);

					if ( dropped != None )
						{

						speed = VSize(Killed.Velocity);
						dropped.RemoteRole = ROLE_DumbProxy;
						dropped.SetPhysics(PHYS_Falling);
						dropped.bCollideWorld = true;
						dropped.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 280);
						weap = dropped;

						if ( weap != None )
							{
							weap.PickupAmmoCount = NumAmmo;
							weap.RespawnTime = 0.0;
							weap.BecomePickup();
							weap.bTossedOut = true;
							weap.bWeaponStay = false;
							weap.GotoState('PickUp', 'Dropped');
							}
						}
					}
				}

			Killed.Inventory.Destroy();

			}
		}

	if ( Killed.IsA('Monsters') && Monsters(Killed).LifeTime > 2 )
		{
		Dice = Rand(100);
		Chance = ChanceHealth;
		if ( Dice < Chance )
			{
			ItemA = Spawn(Class'Item_Health',,,Killed.Location);
			if ( ItemA != None )
				{
				speed = VSize(Killed.Velocity);
				ItemA.MaxPlayerHealth = MaxPlayerHealth;
				ItemA.RemoteRole = ROLE_DumbProxy;
				ItemA.SetPhysics(PHYS_Falling);
				ItemA.bCollideWorld = true;
				ItemA.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 280);
				ItemA.RespawnTime = 0.0;
				ItemA.BecomePickup();
				ItemA.GotoState('PickUp', 'Dropped');
				bDrop = True;
				}
			}
		Chance += ChanceArmor;
		if ( Dice < Chance && !bDrop)
			{
			ItemB = Spawn(Class'Item_Armor',,,Killed.Location);
			if ( ItemB != None )
				{
				speed = VSize(Killed.Velocity);
				ItemB.RemoteRole = ROLE_DumbProxy;
				ItemB.SetPhysics(PHYS_Falling);
				ItemB.bCollideWorld = true;
				ItemB.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 280);
				ItemB.RespawnTime = 0.0;
				ItemB.BecomePickup();
				ItemB.GotoState('PickUp', 'Dropped');
				bDrop = True;
				}
			}
		Chance += ChanceAmmoRegen;
		if ( Dice < Chance && !bDrop )
			{
			ItemC = Spawn(Class'Item_Ammo',,,Killed.Location);
			if ( ItemC != None )
				{
				speed = VSize(Killed.Velocity);
				ItemC.AmmoRegenTime = AmmoRegenTime;
				ItemC.RemoteRole = ROLE_DumbProxy;
				ItemC.SetPhysics(PHYS_Falling);
				ItemC.bCollideWorld = true;
				ItemC.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 280);
				ItemC.RespawnTime = 0.0;
				ItemC.BecomePickup();
				ItemC.GotoState('PickUp', 'Dropped');
				bDrop = True;
				}
			}
		Chance += ChanceImunity;
		if ( Dice < Chance && !bDrop )
			{
			ItemD = Spawn(Class'Item_Imunity',,,Killed.Location);
			if ( ItemD != None )
				{
				speed = VSize(Killed.Velocity);
				ItemD.ImunityTime = ImunityTime;
				ItemD.RemoteRole = ROLE_DumbProxy;
				ItemD.SetPhysics(PHYS_Falling);
				ItemD.bCollideWorld = true;
				ItemD.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 280);
				ItemD.RespawnTime = 0.0;
				ItemD.BecomePickup();
				ItemD.GotoState('PickUp', 'Dropped');
				bDrop = True;
				}
			}
		Chance += ChanceVampire;
		if ( Dice < Chance && !bDrop )
			{
			ItemE = Spawn(Class'Item_Vampire',,,Killed.Location);
			if ( ItemE != None )
				{
				speed = VSize(Killed.Velocity);
				ItemE.VampireTime = VampireTime;
				ItemE.RemoteRole = ROLE_DumbProxy;
				ItemE.SetPhysics(PHYS_Falling);
				ItemE.bCollideWorld = true;
				ItemE.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 280);
				ItemE.RespawnTime = 0.0;
				ItemE.BecomePickup();
				ItemE.GotoState('PickUp', 'Dropped');
				bDrop = True;
				}
			}
		Chance += ChanceLethalAura;
		if ( Dice < Chance && !bDrop )
			{
			ItemF = Spawn(Class'Item_LethalAura',,,Killed.Location);
			if ( ItemF != None )
				{
				speed = VSize(Killed.Velocity);
				ItemF.LethalAuraTime = LethalAuraTime;
				ItemF.RemoteRole = ROLE_DumbProxy;
				ItemF.SetPhysics(PHYS_Falling);
				ItemF.bCollideWorld = true;
				ItemF.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 280);
				ItemF.RespawnTime = 0.0;
				ItemF.BecomePickup();
				ItemF.GotoState('PickUp', 'Dropped');
				bDrop = True;
				}
			}
		Chance += ChanceSpeedBoost;
		if ( Dice < Chance && !bDrop )
			{
			ItemG = Spawn(Class'Item_Speed',,,Killed.Location);
			if ( ItemG != None )
				{
				speed = VSize(Killed.Velocity);
				ItemG.SpeedBoostTime = SpeedBoostTime;
				ItemG.RemoteRole = ROLE_DumbProxy;
				ItemG.SetPhysics(PHYS_Falling);
				ItemG.bCollideWorld = true;
				ItemG.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 280);
				ItemG.RespawnTime = 0.0;
				ItemG.BecomePickup();
				ItemG.GotoState('PickUp', 'Dropped');
				bDrop = True;
				}
			}
		if ( Killer != None && Killed.IsA('Monsters') )
			{
			if ( Killer.IsA('PlayerPawn') || Killer.IsA('Bot') )
				{
				MonsterClass = string(Killed.Class);
				MonsterName = Left(MonsterClass, InStr(MonsterClass, "."));
				Length = Len(MonsterClass) - Len(MonsterName);
				MonsterName = Right(MonsterClass,Length - 1);
				if ( Left(MonsterName, 1) == "E" )
					BroadcastMessage( Killer.PlayerReplicationInfo.PlayerName@"Killed an"@MonsterName, false, 'DeathMessage' );
				else
					BroadcastMessage( Killer.PlayerReplicationInfo.PlayerName@"Killed a"@MonsterName, false , 'DeathMessage');
				}
			}
		}
	if ( TombstoneHealth > 0 )
		{
		T = Spawn(Class'Item_Tombstone',,,Killed.Location);
		if ( T != None )
			{
			T.Lifetime = TombstoneLifetime;
			T.MaxPlayerHealth = MaxPlayerHealth;
			T.HealingAmount = TombstoneHealth;
			T.bRotatingPickup = True;
			T.RotationRate.Yaw = Killed.Rotation.Yaw;
			T.RemoteRole = ROLE_DumbProxy;
			T.SetPhysics(PHYS_Falling);
			T.bCollideWorld = true;
			//T.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 80);
			T.RespawnTime = 0.0;
			T.BecomePickup();
			T.GotoState('PickUp', 'Dropped');
			}
		}

	Num++;

	if ( NextMutator != None )
		//NextMutator.ScoreKill(Killer, Killed);
		NextMutator.PreventDeath(Killed, Killer, damageType, HitLocation);
}

function Timer()
{
local Pawn P, Enemy;
local bool bRed,bBlue,bGreen,bGold;
local int NumTeams;
local int RedScore, BlueScore, GreenScore, GoldScore;
local TournamentGameReplicationInfo GRI;
local MonsterPRI PRI;
local Item_Tombstone T;
local UT_SpriteSmokePuff SP;
local UT_BloodBurst BB;

	ForEach AllActors(class'Item_Tombstone', T)
			{
			if ( T.LifeTime < 0 )
				{
				spawn(class'UT_SpriteSmokePuff',,,T.Location);
				T.Destroy();
				}
			else
				T.LifeTime--;
			}

	if ( bTDM )
		{
		for (P = Level.PawnList; P != None; P = P.NextPawn)
			{
			if ( P.IsA('PlayerPawn') || P.IsA('Bot') )
				{
				if ( P.PlayerReplicationInfo.Team == 0 )
					{
					bRed = True;
					RedScore += P.PlayerReplicationInfo.Score;
					}
				else if ( P.PlayerReplicationInfo.Team == 1 )
					{
					bBlue = True;
					BlueScore += P.PlayerReplicationInfo.Score;
					}
				else if ( P.PlayerReplicationInfo.Team == 2 )
					{
					bGreen = True;
					GreenScore += P.PlayerReplicationInfo.Score;
					}
				else if ( P.PlayerReplicationInfo.Team == 3 )
					{
					bGold = True;
					GoldScore += P.PlayerReplicationInfo.Score;
					}
				}
			}
		if ( bRed )
			NumTeams++;
		if ( bBlue )
			NumTeams++;
		if ( bGreen )
			NumTeams++;
		if ( bGold )
			NumTeams++;
		}

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if (P.IsA('PlayerPawn'))
			{
			PRI = MonsterPRI(PlayerPawn(P).PlayerReplicationInfo);
			GRI = TournamentGameReplicationInfo(PlayerPawn(P).GameReplicationInfo);
			if ( bTDM )
				{
				if ( PRI != none )
					{
					PRI.NumTeams = NumTeams;
					}
				if ( GRI != none)
					{
					GRI.Teams[0].Score = RedScore;
					GRI.Teams[1].Score = BlueScore;
					GRI.Teams[2].Score = GreenScore;
					GRI.Teams[3].Score = GoldScore;
					}
				}
			if ( PRI != none )
				{
				if ( PRI.AmmoRegenTime > 0 ) 
					{
					if ( P.Weapon.AmmoType != none && P.Weapon.AmmoType.AmmoAmount < P.Weapon.AmmoType.MaxAmmo )
						{
						if ( P.Weapon.IsA('minigun2') )
							{
							P.Weapon.AmmoType.AmmoAmount += 10;
							if ( P.Weapon.AmmoType.AmmoAmount > P.Weapon.AmmoType.MaxAmmo )
								P.Weapon.AmmoType.AmmoAmount = P.Weapon.AmmoType.MaxAmmo;
							}
						else if ( !P.Weapon.IsA('WarHeadLauncher') )
							P.Weapon.AmmoType.AmmoAmount += 1;
						}
					PRI.AmmoRegenTime -= 1;
					}
				if ( PRI.ImunityTime > 0 )
					{
					PRI.ImunityTime -= 1;
					}
				if ( PRI.VampireTime > 0 )
					{
					PRI.VampireTime -= 1;
					}
				if ( PRI.LethalAuraTime > 0 )
					{
					PRI.LethalAuraTime -= 1;
					foreach VisibleCollidingActors(class'Pawn', Enemy, LethalAuraRadius, P.Location, true)
						{
						if ( P != Enemy )
							{
							if ( !bTDM )
								{
								Enemy.TakeDamage(AuraDamagePerSecond, P, Enemy.Location, vect(0,0,0), 'aura');
								SP = spawn(class'UT_SpriteSmokePuff',,,Enemy.Location);
								SP.DrawScale = 3;
								BB = spawn(class'UT_BloodBurst',,,Enemy.Location);
								BB.DrawScale = 1;
								}
							else if ( bTDM && P.PlayerReplicationInfo.Team != Enemy.PlayerReplicationInfo.Team )
								{
								Enemy.TakeDamage(AuraDamagePerSecond, P, Enemy.Location, vect(0,0,0), 'aura');
								SP = spawn(class'UT_SpriteSmokePuff',,,Enemy.Location);
								SP.DrawScale = 3;
								BB = spawn(class'UT_BloodBurst',,,Enemy.Location);
								BB.DrawScale = 1;
								}
							}
						}
					}
				if ( PRI.SpeedBoostTime > 0 )
					{
					PRI.SpeedBoostTime -= 1;	
					if ( PRI.SpeedBoostTime <= 0 )
						{
						P.AirControl = P.Default.AirControl;
						P.JumpZ = P.Default.JumpZ;
						P.GroundSpeed = P.Default.GroundSpeed;
						P.WaterSpeed = P.Default.WaterSpeed;
						P.AirSpeed = P.Default.AirSpeed;
						P.Acceleration = P.Default.Acceleration;
						}
					}
					
				PRI.MaxPlayerHealth = MaxPlayerHealth;
				PRI.VampirePercentage = VampirePercentage;
				}
			}
		else if (P.IsA('Monsters'))
			Monsters(P).LifeTime++;
		}
}



defaultproperties
{
MaxPlayerHealth=500
TombstoneHealth=5
AmmoRegenTime=60
MaxAmmoCount=500
ImunityTime=60
SpeedBoostTime=60
LethalAuraTime=60
AuraDamagePerSecond=10
VampireTime=60
VampirePercentage=10
}